<!DOCTYPE html>
<html lang="uk">
<head>
    <? include '_top.php';?>
    <title>Eurobud - Contacts</title>
</head>
<body>
<!-- LOADER -->
<div id="loader-wrapper"></div>

<div id="content-block">
    <!-- HEADER -->
    <header class="header without-banner">
        <? include '_header.php';?>
    </header>

    <!-- MAIN CONTENT -->
    <main class="content">
        <div class="spacer-header"></div>

        <div class="banner-small mr-bottom">
            <div class="wr-hd">
                <div class="bg parallax-bg rellax opacity-01" data-bg='./img/image-00056.jpg'></div>
            </div>
            <div class="container">
                <div class="banner-small-inner text-center">
                    <div class="title h2 md color-white w-bold">Контакти</div>
                </div>
            </div>
        </div>

        <div class="section sp-bottom-sm">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">

                        
                        <div class="tabs tabs-container">
                            <ul class="tabs__caption">
                                <li class="active">Гуртовий продаж</li>
                                <li>Роздріб</li>
                            </ul>

                            <div class="tabs__content-wrap">

                                <div class="tabs__content active">
                                    
                                    <div class="text mr-bottom-50">
                                        <h3>Гуртовий продаж</h3>
                                        <p><b> Обсяг гуртового замовлення</b> пінопласту – від 50 м3. Доставка безкоштовна.<br> 
                                        Якщо обсяг Вашого замовлення пінопласту менший, ніж 50 м3, ознайомтесь, будь ласка, із спеціальними можливостями та сервісами для роздрібних замовників.<br>
                                        Щоб уточнити або розрахувати оптимальний для Вас обсяг замовлення пінопласту, телефонуйте до наших консультантів.</p>
                                        <p><b> Обсяг гуртового замовлення</b> металовиробів уточнюйте, будь ласка, у консультантів «Євробуд». Вони запропонують Вам гнучку систему знижок.</p>
                                    </div>
                                    
                                    <div class="row row-70">
                                        <div class="col-xl-5">
                                            <div class="h5 w-medium">Центральній офіс </div>
                                            <div class="contacts-info-wrap">
                                                <div class="contacts-info">
                                                    <span class="icon">
                                                        <img src="./img/contacts-icon-01.svg" alt="">
                                                    </span>
                                                    <div class="title w-medium color-secondary">Фактична адреса:</div>
                                                    <span>Львівська обл., м. Червоноград, вул. Промислова, 29</span>
                                                </div>
                                                <div class="contacts-info">
                                                    <span class="icon">
                                                        <img src="./img/contacts-icon-02.svg" alt="">
                                                    </span>
                                                    <div class="title w-medium color-secondary">Адреса для поштової кореспонденції:</div>
                                                    <span>Львівська обл., м. Червоноград, вул. Шептицького, 1А, а/c 225</span>
                                                </div>
                                                <div class="contacts-info">
                                                    <span class="icon">
                                                        <img src="./img/contacts-icon-03.svg" alt="">
                                                    </span>
                                                    <div class="title w-medium color-secondary">Телефон:</div>
                                                    <a href="tel:0324942941">(03249) 4-29-41</a>
                                                </div>
                                                <div class="contacts-info">
                                                    <span class="icon">
                                                        <img src="./img/contacts-icon-04.svg" alt="">
                                                    </span>
                                                    <div class="title w-medium color-secondary">Е-mail:</div>
                                                    <a href="mailto:ivan.korol@eurobud.ua">ivan.korol@eurobud.ua</a><br>
                                                    <a href="mailto:sale.dah@eurobud.ua">sale.dah@eurobud.ua</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-7">
                                            <div class='contacts-map block-map'>
                                                <div id="map-canvas" class="map-wrapper" data-lat="50.4044246" data-lng="24.222402" data-zoom="12"></div>
                                                <a class="marker" data-rel="map-canvas" data-lat="50.4044246" data-lng="24.222402" data-image="./img/marker-map.png" data-string="<p>Львів, вул. Садова 2А</p>"></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tabs__content">

                                    <div class="text mr-bottom-50">
                                        <h3>Роздрібний продаж</h3>
                                        <p><b> Обсяг роздрібного замовлення пінопласту</b> до 30 м3. Доставка – самостійне вивезення з точки продажу. безкоштовна.<br> 
                                        Якщо обсяг Вашого замовлення пінопласту менший, ніж 50 м3, ознайомтесь, будь ласка, із спеціальними можливостями та сервісами для роздрібних замовників.<br>
                                        Щоб уточнити або розрахувати оптимальний для Вас обсяг замовлення пінопласту, телефонуйте до наших консультантів.</p>
                                        <p><b>Обсяг роздрібного замовлення</b> металовиробів уточнюйте, будь ласка, у консультантів «Євробуд». Вони запропонують Вам гнучку систему знижок.</p>
                                    </div>

                                    <div class="tabs-wrapper style-02">   
                                        <div class="tab-nav">
                                            <div class="tab-title">
                                                <span>дилери</span>
                                                <i class="icon-arrow"></i>
                                            </div>
                                            <div class="tab-toggle">
                                                <div class="active">дилери</div>
                                                <div>фірмові склади</div>
                                            </div>
                                        </div>
                                        <div class="tab">

                                             <div class="row align-items-center mapplic-tabs-wrapper">
                                                <div class="col-lg-4 order-lg-first order-last">
                                                    <div class="mapplic-tabs">

                                                        <div class="tab-content region-1">
                                                            <div class="text list-style-01">
                                                                <h5><b>Львівська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-2" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Волинська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-3" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Закарпатська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-4" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Рівненська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-5" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Тернопільська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-6" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Івано-Франківська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-7" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Хмельницька область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-8" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Чернівецька область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-10" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Житомирська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-11" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Вінницька область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-8 order-lg-last order-first">
                                                    <div id="mapplic" class="mapplic-active-reg"></div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="tab" style="display: none;">

                                             <div class="row align-items-center mapplic-tabs-wrapper">
                                                <div class="col-lg-4 order-lg-first order-last">
                                                    <div class="mapplic-tabs">

                                                        <div class="tab-content region-1">
                                                            <div class="text list-style-01">
                                                                <h5><b>Львівська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-2" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Волинська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-3" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Закарпатська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-4" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Рівненська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-5" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Тернопільська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-6" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Івано-Франківська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-7" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Хмельницька область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-8" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Чернівецька область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-10" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Житомирська область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                        <div class="tab-content region-11" style="display: none;">
                                                            <div class="text list-style-01">
                                                                <h5><b>Вінницька область</b> <span class="w-light"> 7 дилерів</span></h5>
                                                                <ol>
                                                                    <li>
                                                                        <b>ТзОВ «ЕПІЦЕНТР К» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 302</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Будмакс» </b><br>
                                                                        <span>м. Львів вул. Городоцька, 367 </span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Прем’єрбуд»</b><br>
                                                                        <span>м. Львів, вул. Персенківка, 2</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ фірма «Терміт» </b><br>
                                                                        <span>м. Львів, вул. Зелена, 253</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ФОП Дідич В.,</b><br>
                                                                        <span>м. Львів, вул. Данила Апостола, 9 а</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ПП Богачевський І.В. </b><br>
                                                                        <span>м. Ходорів, вул. Шевченка, 83</span>
                                                                    </li>
                                                                    <li>
                                                                        <b>ТзОВ «Епіцентр», </b><br>
                                                                        <span>м. Стрий, вул. Олега Ольжича, 18</span>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-8 order-lg-last order-first">
                                                    <div id="mapplic1" class="mapplic-active-reg"></div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                   

                                </div>
                            </div>

                            
                        </div>

                        
                    </div>
                </div>
            </div>
        </div>

        <div class="section sp-bottom-xl">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="section sp-top-sm sp-bottom-sm bg-grey-2 dealers-pd-lr">
                            <div class="row justify-content-center">
                                <div class="col-lg-10 text-center">
                                    <div class="h3 w-bold contacts-form-title">У вас з’явились запитання </div>
                                    <div class="contacts-form-subtitle">Напишіть нам і ми зрадістю відповімо на усі ваші запиння</div>
                                    <form class="row row-10 form-group">
                                        <div class="col-lg-12">
                                            <input type="text" class="input" placeholder="Ваше ім’я" required>
                                        </div>
                                        <div class="col-lg-6">
                                            <input type="text" class="input invalid" placeholder="Ваш e-mail" required>
                                        </div>
                                        <div class="col-lg-6">
                                            <input type="text" class="input" placeholder="Ваш телефон" required>
                                        </div>
                                        <div class="col-lg-12">
                                            <textarea class="input" placeholder="Ваше повідомлення"></textarea>
                                            <div class="text-center">
                                                <div class="btn btn-primary blue open-popup" data-rel="thank-popup">
                                                    <!--<input type="submit">-->
                                                    <span>НАДІСЛАТИ</span>
                                                    <span class="anim-border"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </main>

    <!-- FOOTER -->
    <footer class="footer">
        <? include '_footer.php';?>
    </footer>

    <!-- <div class="cookie-message">
        <div class="cookie-message__inner">
            <div class="text">Перегляньте нашу <a href="#">Політику</a> щодо файлів cookie, щоб дізнатися більше.</div>
            <div class="btn-close style02"></div>
        </div>
    </div> -->

</div>

<!-- POPUPS -->
<div class="popup-wrapper">
    <div class="bg-layer"></div>
    <? include '_popups.php';?>
</div>

<? include '_bottom.php';?>


    <!-- MAP -->
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDco0U55FmAwh-agzHOdEirnnduhdy7Nyo"></script>

    <script src="./js/infobox.js"></script>
    <script src="./js/map.js"></script>

    <link rel="stylesheet" type="text/css" href="./css/mapplic.css">
    <script src="./js/mapplic.js"></script>

    <script>
        jQuery(function($) {
            // Inline JSON example
            var mapplicData = {
                "mapwidth":"700",
                "mapheight":"600",
                "levels":[
                    {
                        "id":"uamap",
                        "title":"UAMAP",
                        "map":"img/ua-map.svg",
                        "locations":[
                            {
                                "id": "region-1",
                                "title": "Львівська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.0887",
                                "y": "0.3404"
                            },
                            {
                                "id": "region-2",
                                "title": "Волинська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.1450",
                                "y": "0.1535"
                            },
                            {
                                "id": "region-3",
                                "title": "Закарпатська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.0525",
                                "y": "0.4975"
                            },
                            {
                                "id": "region-4",
                                "title": "Рівненська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.2435",
                                "y": "0.1810"
                            },
                            {
                                "id": "region-5",
                                "title": "Тернопільська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.1860",
                                "y": "0.3770"
                            },
                            {
                                "id": "region-6",
                                "title": "Івано-Франківська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.1380",
                                "y": "0.4555"
                            },
                            {
                                "id": "region-7",
                                "title": "Хмельницька область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.2700",
                                "y": "0.3675"
                            },
                            {
                                "id": "region-8",
                                "title": "Чернівецька область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.2030",
                                "y": "0.5250"
                            },
                            {
                                "id": "region-10",
                                "title": "Житомирська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.3440",
                                "y": "0.2130"
                            },
                            {
                                "id": "region-11",
                                "title": "Вінницька область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.3580",
                                "y": "0.4310"
                            }
                        ]
                    }
                ]
            };

            var customMapplic = $('#mapplic').mapplic({
                source: mapplicData,
                height: 880,
                // developer: true,
                landmark: true,
                search: false,
                // action: 'tooltip',
                lightbox: false,
                sidebar: false,
                minimap: false,
                zoombuttons: false,
                fullscreen: false,
                hovertip: true,
                maxscale: 1,
                zoom: false,
                clearbutton: false
            });

            customMapplic.on('locationopened', function(e, location) {

                var t = $(e.target).parents('.mapplic-tabs-wrapper').find('.mapplic-tabs').find("." + location.id);

                t.siblings('.tab-content:visible').stop().fadeOut(300, function(){
                    t.stop().fadeIn(300);
                });

                $('#mapplic').removeClass('mapplic-active-reg');

            });

            // var selfMapplic = customMapplic.data('mapplic');
            // setTimeout(function(){
            //     $('.mapplic-map-image path#region-1').addClass('mapplic-active');
            // }, 3000)


            var mapplicData1 = {
                "mapwidth":"700",
                "mapheight":"600",
                "levels":[
                    {
                        "id":"uamap",
                        "title":"UAMAP",
                        "map":"img/ua-map.svg",
                        "locations":[
                            {
                                "id": "region-1",
                                "title": "Львівська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.0887",
                                "y": "0.3404"
                            },
                            {
                                "id": "region-2",
                                "title": "Волинська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.1450",
                                "y": "0.1535"
                            },
                            {
                                "id": "region-3",
                                "title": "Закарпатська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.0525",
                                "y": "0.4975"
                            },
                            {
                                "id": "region-4",
                                "title": "Рівненська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.2435",
                                "y": "0.1810"
                            },
                            {
                                "id": "region-5",
                                "title": "Тернопільська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.1860",
                                "y": "0.3770"
                            },
                            {
                                "id": "region-6",
                                "title": "Івано-Франківська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.1380",
                                "y": "0.4555"
                            },
                            {
                                "id": "region-7",
                                "title": "Хмельницька область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.2700",
                                "y": "0.3675"
                            },
                            {
                                "id": "region-8",
                                "title": "Чернівецька область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.2030",
                                "y": "0.5250"
                            },
                            {
                                "id": "region-10",
                                "title": "Житомирська область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.3440",
                                "y": "0.2130"
                            },
                            {
                                "id": "region-11",
                                "title": "Вінницька область",
                                "description": "7 дилерів",
                                "fill":"false",
                                "pin": "transparent",
                                "x": "0.3580",
                                "y": "0.4310"
                            }
                        ]
                    }
                ]
            };

            var customMapplic1 = $('#mapplic1').mapplic({
                source: mapplicData1,
                height: 880,
                // developer: true,
                landmark: true,
                search: false,
                // action: 'tooltip',
                lightbox: false,
                sidebar: false,
                minimap: false,
                zoombuttons: false,
                fullscreen: false,
                hovertip: true,
                maxscale: 1,
                zoom: false,
                clearbutton: false
            });

            customMapplic1.on('locationopened', function(e, location) {

                var t = $(e.target).parents('.mapplic-tabs-wrapper').find('.mapplic-tabs').find("." + location.id);

                t.siblings('.tab-content:visible').stop().fadeOut(300, function(){
                    t.stop().fadeIn(300);
                });

                $('#mapplic1').removeClass('mapplic-active-reg');

            });

        });
    </script>



</body>
</html>