var _functions = {};

jQuery(function($) {

	"use strict";

	/*###############*/
	/* FUNCTION ON DOCUMENT READY */ 
	/*###############*/

	if (navigator.userAgent.indexOf("Firefox") >= 0) {
		$('body').addClass('firefox');
	}
	if (navigator.userAgent.indexOf('Edge') >= 0) {
		$('body').addClass('edge');
	}
	if (navigator.userAgent.indexOf("Trident") >= 0) {
		$('body').addClass('ie');
	}
	if (navigator.userAgent.indexOf('Safari') >= 0 && navigator.userAgent.indexOf('Chrome') < 0) {
		$('body').addClass('safari');
	}
	if (navigator.userAgent.indexOf('Chrome') >= 0 && navigator.userAgent.indexOf('Edge') < 0) {
		$('body').addClass('chrome');
	}

	setTimeout( function(){
		$("#loader-wrapper").fadeOut(0);
	},100);

	$('[data-bg]').each(function(i, el){
		$(el).css({'background-image': 'url('+$(el).data('bg')+')'});
	});

	$('img[data-src]').each(function(i, el){
		$(el).attr({'src': $(el).data('src')});
	});

	/*###############*/
	/* ANIMATIONS */
	/*###############*/

	_functions.customAnimation = function() {
		if ($('.animation').length) {
			$('.animation').each(function() {
				if ($(this).offset().top < $(window).scrollTop() + $(window).height()) {
					$(this).addClass('animated');
				}
			});
		}
	}
	_functions.scrollHeadern = function() {
		var a = $(window).scrollTop();

        if(a > 20) {
			$('.header').addClass('scrolled');
        } else if(a < 20) {
			$('.header').removeClass('scrolled');
        }
	}

	/*###############*/
	/* SCROLL */
	/*###############*/

	$(window).on('scroll load', function(){
		_functions.customAnimation();
		_functions.scrollHeadern();
	});

	/*###############*/
	/* INPUT MATERIAL */
	/*###############*/

	$('.input-wrapper-material .input-material').on('focus', function(){
		$(this).parent().addClass('focus');
	});
	$('.input-wrapper-material .input-material').on('blur', function () {
		$(this).parent().removeClass('focus');
	});
	$('.input-wrapper-material .input-material').on('keyup', function () {
		if(!$(this).val()) $(this).parent().removeClass('typed');
		else $(this).parent().addClass('typed');
	});

	/*###############*/
	/* POPUP */
	/*###############*/

	var popupTop = 0;
	function removeScroll() {
		popupTop = $(window).scrollTop();
		$('html').css({
			"position": "fixed",
			"top": -$(window).scrollTop(),
			"width": "100%"
		});
	}
	function addScroll() {
		$('html').css({
			"position": "static"
		});
		window.scroll(0, popupTop);
	}
	_functions.openPopup = function(popup){
		$('.popup-content').removeClass('active');
		$(popup + ', .popup-wrapper').addClass('active');
		removeScroll();
	};

	_functions.closePopup = function(){
		$('.popup-wrapper, .popup-content').removeClass('active');
		addScroll();
	};

	_functions.textPopup = function(title, description){
		$('#text-popup .text-popup-title').html(title);
		$('#text-popup .text-popup-description').html(description);
		_functions.openPopup('#text-popup');
	};

	$(document).on('click', '.open-popup', function(e){
		e.preventDefault();
		_functions.openPopup('.popup-content[data-rel="' + $(this).data('rel') +'"]');
	});

	$(document).on('click', '.popup-wrapper .btn-close, .popup-wrapper .close-popup, .popup-wrapper .layer-close, .popup-wrapper .close-popup', function(e){
		e.preventDefault();
		_functions.closePopup();
	});

	// thanks popup

	_functions.thanksPopup = function(){
		event.preventDefault();
		_functions.openPopup('.popup-content[data-rel="thanks-popup"]');
		
		// setTimeout( function(){
		// 	_functions.closePopup();
		// },3000);
	};


	/*###############*/
	/* SELECT */
	/*###############*/

	$('.select').SumoSelect();


	/*###############*/
	/* TABS */
	/*###############*/

	$('.tab-title').on('click', function() {
        $(this).parent().toggleClass('active');
    });
	

    $('.tab-toggle div').on('click', function() {

        var tab = $(this).closest('.tabs-wrapper').children('.tab');
        var i = $(this).index();

        $(this).addClass('active').siblings().removeClass('active');

        tab.eq(i).siblings('.tab:visible').stop().fadeOut(300, function(){
        	tab.eq(i).stop().fadeIn(300);
        });
        

        $(this).closest('.tab-nav').removeClass('active').find('.tab-title span').text($(this).find('.title').text());

    });



    /*###############*/
	/* DROP MENU */
	/*###############*/

    $('.drop-menu-inner').on('click', function(){
    	$(this).parents('.drop-menu').toggleClass('active');
    })

    /*###############*/
	/* SLIDER RANGE */
	/*###############*/

	_functions.initRange = function(el){

		noUiSlider.create(el[0], {
			start: [$(el[0]).data('start'), $(el[0]).data('end')],
			connect: true,
			step: 1,
			range: {
				'min': $(el).data('min'),
				'max': $(el).data('max')
			}
		});

		var minCostInput = $(el[0]).parents('.filters-range').find('.minCost'),
			maxCostInput = $(el[0]).parents('.filters-range').find('.maxCost');
		

		el[0].noUiSlider.on('update', function( values, handle ) {

			if ( handle ) {
				maxCostInput.val(~~values[handle]);
			} else {
				minCostInput.val(~~values[handle]);
			}

		});


		minCostInput[0].addEventListener('change', function(){
			el[0].noUiSlider.set([this.value, null]);
		});

		maxCostInput[0].addEventListener('change', function(){
			el[0].noUiSlider.set([null, this.value]);
		});

	};

	$('.slider-range').each(function () {
		_functions.initRange($(this));
	});


	/*###############*/
	/* BTN VIEW */
	/*###############*/
 	

 	$('.product-list-btn').on('click', function(){
 		$(this).addClass('active').siblings('.btn').removeClass('active');
 		$('.view-grid').slideUp(function(){
 			$('.view-list').slideDown();
 		});

 	});
 	$('.product-grid-btn').on('click', function(){
 		$(this).addClass('active').siblings('.btn').removeClass('active');
 		$('.view-list').slideUp(function(){
 			$('.view-grid').slideDown();
 		});

 	});

 	/*###############*/
	/* accordeon*/
	/*###############*/

 	$('.filters-accor .title').on('click', function(){
 		$(this).toggleClass('active');
 		$(this).siblings('.content').slideToggle();
 	})

 	$('.product-filters-btn').on('click', function(){
 		console.log('asdfasdf')
 		$(this).parents('.product-filters').toggleClass('active');
 	})

 	$('.filters-fav .item .delete').on('click', function(){
 		$(this).closest('.item').remove();
 	});



 	/*###############*/
	/* Social Block*/
	/*###############*/

	_functions.ElemFixed = function(){

		var $elSoc = $('.social-block'),
			bottom = 250,
	  		getStyleBt = parseFloat($elSoc.css("bottom"));

	 	$(window).on('scroll load',  function(e){ 
		  if ($(document).height() < $(this).scrollTop() + window.innerHeight + bottom - getStyleBt){
		    $elSoc.css({'position': 'absolute', 'bottom': bottom});
		  } else{
			$elSoc.removeAttr('style');
		  }
		});
	}
	_functions.ElemFixed();

 	

});
 